/*
 * Vector2.java
 *
 * Created on 11 de diciembre de 2002, 07:06 PM
 */

/**
 *
 * @author  Administrador
 * @version 
 */
import java.util.*;

public class Vector2 extends java.util.Vector{
    
    Maquina inicial;
    private int numeroCintas;
    private String nombreLargo;
    private String nombreCorto;
    private String descripcion;
    private String dependencia;
    private boolean principal;
    private boolean monocinta;
    /** Creates new Vector2 */
    public Vector2() {
        super();
        monocinta = true;
    }
    
    public boolean add(Object o){
        
        if(this.size()==0){
            inicial = (Maquina)o;
            inicial.setInicial(true);
        }
        
        return super.add(o);
    }
    
    public boolean add2(Object o){
         
        return super.add(o);
    }
    
    public boolean remove(Object o){

        if(this.size()==1) this.inicial=null;        
        return super.remove(o);
    }
    
    public Vector getParametros(){
        
        Vector vout = new Vector();
        Enumeration en = this.elements();
        
        while(en.hasMoreElements()){
            
            Maquina maquina = (Maquina)en.nextElement();
            if(maquina instanceof Enlace_1){
                
                Enumeration operandosDerecho = ((Enlace_1)maquina).condicionEnlace.operandosDerecho.elements();
                while(operandosDerecho.hasMoreElements()){
                    Vector operandos = (Vector)operandosDerecho.nextElement();
                    Enumeration enOp = operandos.elements();
                    while(enOp.hasMoreElements()){
                        String nombre = (String)enOp.nextElement();
                        if(CondicionEnlace.isNombreParametro(nombre)&&!vout.contains(nombre))
                            vout.add(nombre);
                    }
                }
            }
            else if(maquina instanceof Escritora){
                
                if(CondicionEnlace.isNombreParametro(maquina.getNombre())&&!vout.contains(maquina.getNombre()))
                    vout.add(maquina.getNombre());
            }
            
        }
        
        return vout;
        
    }
    
    
    public void refreshSubmaquinas(){
        
        Enumeration en = this.elements();
        
        while(en.hasMoreElements()){        
            Maquina maquina = (Maquina)en.nextElement();
            if(maquina instanceof Submaquina) ((Submaquina)maquina).refreshParametros(true);    
        } 
    }
    
    public String getXML(){
        
       /* <!ELEMENT maquina (parametro*, R*, L*, escritora*, submaquina*, buscadora-L*, 
                   buscadora-L-NOT*, buscadora-R*, buscadora-R-NOT*, SR*, SL*,
                   concentrador*, enlace-compuesto*)>*/
                   
        Vector maquinasR = new Vector();
        Vector maquinasL = new Vector();
        Vector escritoras = new Vector();
        Vector submaquinas = new Vector();
        Vector buscadorasL = new Vector();
        Vector buscadorasLNOT = new Vector();
        Vector buscadorasR = new Vector();
        Vector buscadorasRNOT = new Vector();
        Vector maquinasSR = new Vector();
        Vector maquinasSL = new Vector();
        Vector concentradores = new Vector();
        //Vector enlacesCompuestos = new Vector();
     
        Enumeration en = this.elements();
        
        String xml="";
        xml+="<maquina\n";
        xml+="  nombre-largo=\""+this.nombreLargo+"\"\n";
        xml+="  nombre-corto=\""+this.nombreCorto+"\"\n";
        xml+="  descripcion=\""+this.descripcion+"\"\n";
        xml+="  numero-cintas=\""+this.numeroCintas+"\"\n";
        xml+="  principal=\""+this.principal+"\"\n";
        xml+="  dependencia=\""+this.dependencia+"\"\n";
        xml+=">\n";
        
        while(en.hasMoreElements()){
            
            Maquina maquina = (Maquina)en.nextElement();
            
            if(maquina instanceof R){ 
                maquinasR.add(maquina);
                continue;
            }
            
            if(maquina instanceof L){
                maquinasL.add(maquina);
                continue;
            }
            
            if(maquina instanceof Escritora){
                escritoras.add(maquina);
                continue;
            }
            
            if(maquina instanceof Submaquina && maquina.getNombre().equals("M")){
                submaquinas.add(maquina);
                continue;
            }
            
            if(maquina instanceof Submaquina && maquina.getNombre().equals("L") && !((Submaquina)maquina).isNot()){
                buscadorasL.add(maquina);
                continue;
            }
            
            if(maquina instanceof Submaquina && maquina.getNombre().equals("L") && ((Submaquina)maquina).isNot()){
                buscadorasLNOT.add(maquina);
                continue;
            }
            
            if(maquina instanceof Submaquina && maquina.getNombre().equals("R") && !((Submaquina)maquina).isNot()){
                buscadorasR.add(maquina);
                continue;
            }
            
            if(maquina instanceof Submaquina && maquina.getNombre().equals("R") && ((Submaquina)maquina).isNot()){
                buscadorasRNOT.add(maquina);
                continue;
            }
            
            if(maquina instanceof Submaquina && maquina.getNombre().equals("S") && ((Submaquina)maquina).parametros.containsKey("L")){
                maquinasSL.add(maquina);
                continue;
            }
            
            if(maquina instanceof Submaquina && maquina.getNombre().equals("S") && ((Submaquina)maquina).parametros.containsKey("R")){
                maquinasSR.add(maquina);
                continue;
            }
            
            if(maquina instanceof Concentrador){
                concentradores.add(maquina);
                continue;
            }
            
            /*if(maquina.proxima instanceof EnlaceCompuesto_1){
                enlacesCompuestos.add(maquina);
                continue;
            }*/
        }
        
        en = null;
        en = maquinasR.elements();
        while(en.hasMoreElements()){
            Maquina maquina = (Maquina)en.nextElement();
            xml+=maquina.getXML();
        }
        
        en = null;
        en = maquinasL.elements();
        while(en.hasMoreElements()){
            Maquina maquina = (Maquina)en.nextElement();
            xml+=maquina.getXML();
        }
        
        en = null;
        en = escritoras.elements();
        while(en.hasMoreElements()){
            Maquina maquina = (Maquina)en.nextElement();
            xml+=maquina.getXML();
        }
        
        en = null;
        en = submaquinas.elements();
        while(en.hasMoreElements()){
            Maquina maquina = (Maquina)en.nextElement();
            xml+=maquina.getXML();
        }
        
        en = null;
        en = buscadorasL.elements();
        while(en.hasMoreElements()){
            Maquina maquina = (Maquina)en.nextElement();
            xml+=maquina.getXML();
        }
        
        en = null;
        en = buscadorasLNOT.elements();
        while(en.hasMoreElements()){
            Maquina maquina = (Maquina)en.nextElement();
            xml+=maquina.getXML();
        }
        
        en = null;
        en = buscadorasR.elements();
        while(en.hasMoreElements()){
            Maquina maquina = (Maquina)en.nextElement();
            xml+=maquina.getXML();
        }
        
        en = null;
        en = buscadorasRNOT.elements();
        while(en.hasMoreElements()){
            Maquina maquina = (Maquina)en.nextElement();
            xml+=maquina.getXML();
        }
        
        en = null;
        en = maquinasSR.elements();
        while(en.hasMoreElements()){
            Maquina maquina = (Maquina)en.nextElement();
            xml+=maquina.getXML();
        }
        
        en = null;
        en = maquinasSL.elements();
        while(en.hasMoreElements()){
            Maquina maquina = (Maquina)en.nextElement();
            xml+=maquina.getXML();
        }
        
        en = null;
        en = concentradores.elements();
        while(en.hasMoreElements()){
            Maquina maquina = (Maquina)en.nextElement();
            xml+=maquina.getXML();
        }
  
        /*en = null;
        en = enlacesCompuestos.elements();
        while(en.hasMoreElements()){
            Maquina maquina = (Maquina)en.nextElement();
            xml+=maquina.getXML();
        }*/

        /*while(en.hasMoreElements()){        
            Maquina maquina = (Maquina)en.nextElement();
            if(!(maquina instanceof Enlace_1)) xml+=maquina.getXML();
        }*/
        
        en=null;
        en = this.elements();
        while(en.hasMoreElements()){        
            Maquina maquina = (Maquina)en.nextElement();
            if(maquina.proxima instanceof EnlaceCompuesto_1) xml+=maquina.proxima.getXML();
        }
        
        xml+="</maquina>\n";
        
        return xml;
        
    }
    
    public void searchAndSetInicial(){
        
        Enumeration en = this.elements();
        
        while(en.hasMoreElements()){
            this.inicial = (Maquina)en.nextElement();
            if(inicial.isInicial()) return;
        }
    }
    
    /** Getter for property numeroCintas.
     * @return Value of property numeroCintas.
     */
    public int getNumeroCintas() {
        return numeroCintas;
    }
    
    /** Setter for property numeroCintas.
     * @param numeroCintas New value of property numeroCintas.
     */
    public void setNumeroCintas(int numeroCintas) {
        this.numeroCintas = numeroCintas;
    }
    
    public void incrNumeroCintas(){
        this.numeroCintas++;
    }
    
    public void decrNumeroCintas(){
        
        this.numeroCintas--;
    }
    
    /** Getter for property nombreLargo.
     * @return Value of property nombreLargo.
     */
    public java.lang.String getNombreLargo() {
        return nombreLargo;
    }
    
    /** Setter for property nombreLargo.
     * @param nombreLargo New value of property nombreLargo.
     */
    public void setNombreLargo(java.lang.String nombreLargo) {
        this.nombreLargo = nombreLargo;
    }
    
    /** Getter for property nombreCorto.
     * @return Value of property nombreCorto.
     */
    public java.lang.String getNombreCorto() {
        return nombreCorto;
    }
    
    /** Setter for property nombreCorto.
     * @param nombreCorto New value of property nombreCorto.
     */
    public void setNombreCorto(java.lang.String nombreCorto) {
        this.nombreCorto = nombreCorto;
    }
    
    /** Getter for property descripcion.
     * @return Value of property descripcion.
     */
    public java.lang.String getDescripcion() {
        return descripcion;
    }
    
    /** Setter for property descripcion.
     * @param descripcion New value of property descripcion.
     */
    public void setDescripcion(java.lang.String descripcion) {
        this.descripcion = descripcion;
    }
    
    /** Getter for property dependencia.
     * @return Value of property dependencia.
     */
    public java.lang.String getDependencia() {
        return dependencia;
    }
    
    /** Setter for property dependencia.
     * @param dependencia New value of property dependencia.
     */
    public void setDependencia(java.lang.String dependencia) {
        this.dependencia = dependencia;
    }
    
    /** Getter for property principal.
     * @return Value of property principal.
     */
    public boolean isPrincipal() {
        return principal;
    }
    
    /** Setter for property principal.
     * @param principal New value of property principal.
     */
    public void setPrincipal(boolean principal) {
        this.principal = principal;
    }
    
    /** Getter for property monocinta.
     * @return Value of property monocinta.
     */
    public boolean isMonocinta() {
        return monocinta;
    }
    
    /** Setter for property monocinta.
     * @param monocinta New value of property monocinta.
     */
    public void setMonocinta(boolean monocinta) {
        this.monocinta = monocinta;
    }
    
    public static Vector getCalledMachines(String nombreLargo,Hashtable dicOfMachines){
        
        Vector out = new Vector();
        
        Enumeration en = dicOfMachines.elements();
        while(en.hasMoreElements()){
            Vector2 vector2 = (Vector2)en.nextElement();
            /*if(vector2.getDependencia()==null) {
                System.out.println(vector2.getNombreLargo()+" tiene la dependencia nula");
                continue;
            }*/
            if(vector2.getDependencia().equals(nombreLargo) && !vector2.isPrincipal()) out.add(vector2);         
        }
        
        return out;
    }
    
    
}
