

//Title:        Proyecto Turing Visual

//Version:      

//Copyright:    Copyright (c) 1998

//Author:       Marco Antonio Mora Godoy

//Company:      Your Company

//Description:  No admires, CREA!!!!...









import java.awt.*;
import java.awt.font.FontRenderContext;
import java.lang.*;
import java.util.Enumeration;
import javax.swing.JOptionPane;
import javax.swing.*;

public abstract class Maquina implements Cloneable{

    public static int idContador=0;
    public static boolean displayIndex=true;
    public static boolean flagUR=false;
    //public static boolean idContadorActivado;
    public int idMaquina;

    int x0,y0;
    Cinta cinta;
    private int indiceCinta;
    
    Maquina previa,proxima;
    public static Maquina playMachine;
    public static Maquina selectedMachine;
    public static boolean oldNotation = true;
    public static boolean running=false;
    protected int iconValue;
    protected String nombre;
    protected Rectangle boundRectangle,leftRectangle,rightRectangle;
    protected boolean inicial;

    static final Font FONT_TRI30=new Font("TIMESROMAN",Font.ITALIC,30);
    static final Font FONT_TRI25=new Font("TIMESROMAN",Font.ITALIC,25);
    static final Font FONT_TRI20=new Font("TIMESROMAN",Font.ITALIC,20);
    static final Font FONT_TRP19=new Font("TIMESROMAN",Font.PLAIN,19);
    static final Font FONT_TRI16=new Font("TIMESROMAN",Font.ITALIC,16);
    static final Font FONT_TRP16=new Font("TIMESROMAN",Font.PLAIN,16);
    static final Font FONT_TRI14=new Font("TIMESROMAN",Font.ITALIC,14);
    static final Font FONT_TRP13=new Font("TIMESROMAN",Font.PLAIN,13);
    static final Font FONT_TRI13=new Font("TIMESROMAN",Font.ITALIC,13);
    static final Font FONT_TRP10=new Font("TIMESROMAN",Font.PLAIN,10);
    static final Font FONT_AP13=new Font("ARIAL",Font.PLAIN,13);
    static final Font FONT_AP10=new Font("ARIAL",Font.PLAIN,10);
    static final Font FONT_AP8=new Font("ARIAL",Font.PLAIN,8);
    static final Font FONT_AP7=new Font("ARIAL",Font.PLAIN,7);
    
    static final String SIMBOLO_INICIAL = ">";
    static final java.awt.geom.Rectangle2D RECT_INICIAL = Maquina.FONT_TRI25.getStringBounds(SIMBOLO_INICIAL,new FontRenderContext(Maquina.FONT_TRI25.getTransform(),true,true));
    

    //static final int delta_x=19;
    static final int delta_x=10;

    //static final int delta_y=17;
    static final int delta_y=15;

    static final int ESTADO_DORMIDA=0; 
    static final int ESTADO_COLGADA=1;
    static final int ESTADO_VAR_NO_SET=2;
    static final int ESTADO_PAR_NO_SET=3;
    static final int ESTADO_HALT=4;
    static final int ESTADO_ND=5;
    static final int ESTADO_EXPANDIBLE=6;
    static final int ESTADO_RECHAZA=7;
    
    static boolean dibujaRecursivo=false;

    Maquina(int x,int y,Cinta c,Maquina prev,Maquina prox){

      x0=x;

      y0=y;

      cinta = c;

      previa = prev;

      proxima = prox;
      
      //if(idContadorActivado) 
      idMaquina = ++idContador;

    }



    Maquina(Cinta c,Maquina prev, Maquina prox){



      cinta = c;

      previa = prev;

      proxima = prox;

      //if(idContadorActivado) 
      idMaquina = ++idContador;

    }
    
    Maquina(int x,int y,int _indiceCinta,Maquina _previa,Maquina _proxima){
        
      x0=x;

      y0=y;

      indiceCinta = _indiceCinta;

      previa = _previa;

      proxima = _proxima;
      
      //if(idContadorActivado) 
      idMaquina = ++idContador;
        
        
    }







    Maquina(int x, int y){



      x0=x;

      y0=y;

      //if(idContadorActivado) 
      idMaquina = ++idContador;

    }



    Maquina(){



      x0=y0=0;

      cinta = null;

      previa = proxima = null;

      //if(idContadorActivado) 
      idMaquina = ++idContador;

    }


    public void accion(){
        
            if(proxima!=null) proxima.accion();
    }

    public void accion(Cinta _cinta){
        
    }
    
    public boolean accion(Cinta _arrayOfTapes[],DiccionarioMetavalores dicMetavalores){
    
         return true;
    }


    public void dibujar(Graphics g){
        
         /*if(this.boundRectangle!=null){
             g.setColor(Color.green);
             g.drawRect((int)boundRectangle.getX(),(int)boundRectangle.getY(),(int)boundRectangle.getWidth(),(int)boundRectangle.getHeight());
             g.setColor(Color.black);
         }*/
        
        /*if(this.leftRectangle!=null){
             g.setColor(Color.green);
             g.drawRect((int)leftRectangle.getX(),(int)leftRectangle.getY(),(int)leftRectangle.getWidth(),(int)leftRectangle.getHeight());
             g.setColor(Color.black);
         }
        
        if(this.rightRectangle!=null){
             g.setColor(Color.cyan);
             g.drawRect((int)rightRectangle.getX(),(int)rightRectangle.getY(),(int)rightRectangle.getWidth(),(int)rightRectangle.getHeight());
             g.setColor(Color.black);
         }*/
        
          if(proxima!=null && Maquina.dibujaRecursivo) proxima.dibujar(g);
        
        
    }

    public void setCinta(Cinta _cinta){
        
        cinta = _cinta;
        
    }
    
    public Cinta getCinta(){
        
        return cinta;
        
    }
    
    public void setIndiceCinta(int _indiceCinta){
        
        indiceCinta = _indiceCinta;
        
    }
    
    public int getIndiceCinta(){
        
        return indiceCinta;
    }
    
    public int getMaxIndiceCinta(){
        
        return indiceCinta;
    }
    
    public void setPrevMaquina(Maquina _previa){
        
        previa = _previa;
       
    }
    
    
    public void setProxMaquina(Maquina _proxima){
        
        proxima = _proxima;
        
        
    }
    
    public void setIconValue(int _iconValue){
        
        iconValue = _iconValue;
    }
    
    public int getIconValue(){
        
        return iconValue;
    }
    
    public void setNombre(String _nombre){
        
        nombre = _nombre;
        java.awt.geom.Rectangle2D rect = getBounds(); //Maquina.FONT_TRI25.getStringBounds(getNombre(),new FontRenderContext(Maquina.FONT_TRI25.getTransform(),true,true));
        boundRectangle = new Rectangle(x0,y0-(int)Math.abs(0.8*rect.getHeight()),(int)Math.abs(rect.getWidth()),(int)Math.abs(0.8*rect.getHeight()));
        leftRectangle = new Rectangle(x0,y0-(int)Math.abs(0.8*rect.getHeight()),(int)Math.abs(0.5*rect.getWidth())+2,(int)Math.abs(0.8*rect.getHeight()));
        rightRectangle = new Rectangle(x0+(int)Math.abs(0.5*rect.getWidth()),y0-(int)Math.abs(0.8*rect.getHeight()),(int)Math.abs(0.5*rect.getWidth())+2,(int)Math.abs(0.8*rect.getHeight()));  
    }
    
    public String getNombre(){
       
        return nombre;
        
    }
    
    public java.awt.geom.Rectangle2D getBounds(){
        
        return Maquina.FONT_TRI25.getStringBounds(getNombre(),new FontRenderContext(Maquina.FONT_TRI25.getTransform(),true,true));
    }
    
    public boolean esInicial(){
        
          return previa==null && proxima!=null;
        
    }
    
    public boolean esEnlazable(){
        
            return true;
    }
    
   public boolean isMouseClicked(int x,int y){
     
        return false;
   }
    
    public void insertMachine(Maquina newMachine,boolean leftInsert,java.util.Vector repository){
        
        if(leftInsert){
            Maquina oldPrevia = this.previa;
            this.setPrevMaquina(newMachine);
            newMachine.setProxMaquina(this);
            if(oldPrevia!=null){
                oldPrevia.setProxMaquina(newMachine);
                newMachine.setPrevMaquina(oldPrevia);
            }
            newMachine.moveRewind(newMachine.getDelta());
            if(this.isInicial()){
                this.setInicial(false);
                newMachine.setInicial(true);
                ((Vector2)repository).inicial = newMachine;
            }
            //System.out.println("CASO 1");
        }
        else{
            Maquina oldProxima = this.proxima;
            if(!(oldProxima instanceof EnlaceCompuesto_1)){
                this.setProxMaquina(newMachine);
                newMachine.setPrevMaquina(this);
                if(oldProxima!=null){
                    newMachine.setProxMaquina(oldProxima);
                    oldProxima.setPrevMaquina(newMachine);
                }
                newMachine.moveForward(this.getDelta());
                //System.out.println("CASO 2");
            }
            else{
                this.setProxMaquina(newMachine);
                newMachine.setPrevMaquina(this);
                newMachine.setProxMaquina(oldProxima);
                oldProxima.setPrevMaquina(newMachine);
                Enumeration en = ((EnlaceCompuesto_1) oldProxima).getEnlaces();
                while(en.hasMoreElements()){
                    Enlace_1 enlace = (Enlace_1)en.nextElement();
                    enlace.setPrevMaquina(newMachine);
                }
                for(int i=0;i<repository.size();i++)
                if((repository.get(i) instanceof Enlace_1) && ((Maquina)repository.get(i)).proxima==this)
                    ((Enlace_1)repository.get(i)).setProxMaquina(newMachine);
                newMachine.moveForward(this.getDelta()); //this.getDelta());
                //System.out.println("CASO 3");
                //JOptionPane.showMessageDialog(null, "No se permite la insercin a la derecha cuando existen enlaces","JTV",JOptionPane.WARNING_MESSAGE);
                //return false;
            }
            
            
        }
        
        repository.add(newMachine);
    }
    
    
    public void deleteMachine(java.util.Vector repository){
        
        if(previa!=null && proxima!=null && !(proxima instanceof EnlaceCompuesto_1)){ 
            //CASO 1
            //System.out.println("CASO 1 y 5");
            previa.setProxMaquina(proxima);
            proxima.setPrevMaquina(previa);
            previa.moveForward2(this.getDelta());
            //CASO 5
            Comando comando = Comando.getLastComando();
            Comando inverse = comando.getInverse();
            for(int i=0;i<repository.size();i++)
                if((repository.get(i) instanceof Enlace_1) && ((Maquina)repository.get(i)).proxima==this){                   
                    ((Enlace_1)repository.get(i)).setProxMaquina(proxima);
                    if(Comando.flagDelete){
                        comando.addComando(new ComandoEPRX(repository.get(i),(Vector2)repository,proxima));
                        inverse.addComando(new ComandoEPRX(repository.get(i),(Vector2)repository,this));
                    }
                }
            repository.remove(this);
            return;
        }
        else if(previa!=null && (proxima instanceof EnlaceCompuesto_1)){
            //CASO 2
            //System.out.println("CASO 2");
            previa.setProxMaquina(proxima);
            previa.moveForward2(this.getDelta());
            Enumeration enlaces = ((EnlaceCompuesto_1)proxima).getEnlaces();
            while(enlaces.hasMoreElements()){
                Enlace_1 enlace = (Enlace_1)enlaces.nextElement();
                enlace.setPrevMaquina(previa);
                if(enlace instanceof AutoEnlace) enlace.setProxMaquina(previa);
            }
            Comando comando = Comando.getLastComando();
            Comando inverse = comando.getInverse();
            for(int i=0;i<repository.size();i++)
                if((repository.get(i) instanceof Enlace_1) && ((Maquina)repository.get(i)).proxima==this){
                    ((Enlace_1)repository.get(i)).setProxMaquina(previa);
                    if(Comando.flagDelete){
                        comando.addComando(new ComandoEPRX(repository.get(i),(Vector2)repository,previa));
                        inverse.addComando(new ComandoEPRX(repository.get(i),(Vector2)repository,this));
                    }
                }
            repository.remove(this);
            return;
        }
        else if(previa!=null && proxima==null){
            //CASO 8
            //System.out.println("CASO 8");
            previa.setProxMaquina(proxima);
            previa.moveForward2(this.getDelta());
            Comando comando = Comando.getLastComando();
            Comando inverse = comando.getInverse();
            for(int i=0;i<repository.size();i++)
                if((repository.get(i) instanceof Enlace_1) && ((Maquina)repository.get(i)).proxima==this){
                    ((Enlace_1)repository.get(i)).setProxMaquina(previa);
                    if(Comando.flagDelete){
                        comando.addComando(new ComandoEPRX(repository.get(i),(Vector2)repository,previa));
                        inverse.addComando(new ComandoEPRX(repository.get(i),(Vector2)repository,this));
                    }
                }
            repository.remove(this);
            return;
        }
        else if(previa==null && (proxima instanceof EnlaceCompuesto_1)){
            //CASO 4
            //System.out.println("CASO 4");
            Enumeration enlaces = ((EnlaceCompuesto_1)proxima).getEnlaces();
            java.util.Vector enlacesRemovidos = new java.util.Vector();
            while(enlaces.hasMoreElements()){
                Enlace_1 enlace = (Enlace_1)enlaces.nextElement();
                //enlace.proxima.setPrevMaquina(null);
                //repository.remove(enlace);
                enlacesRemovidos.add(enlace);
                enlace=null;
            }
            //java.util.Vector enlacesRemovidos = new java.util.Vector();
            for(int i=0;i<repository.size();i++)
                if(repository.get(i) instanceof Enlace_1 && !(repository.get(i) instanceof AutoEnlace) && ((Maquina)repository.get(i)).proxima==this){
                    //if(!(repository.get(i) instanceof AutoEnlace)) ((Maquina)repository.get(i)).previa.setProxMaquina(null);
                    enlacesRemovidos.add(repository.get(i));
                }
            Comando comando = Comando.getLastComando();
            Comando inverse = comando.getInverse();
            Enumeration enRem = enlacesRemovidos.elements();
            while(enRem.hasMoreElements()){
                //ComandoIML = comando
                Enlace_1 enlace = (Enlace_1) enRem.nextElement();                
                enlace.deleteMachine(repository);
                if(Comando.flagDelete){
                    comando.addComando(new ComandoEM(enlace,(Vector2)repository));
                    inverse.addComando(new ComandoIE(enlace,(Vector2)repository));
                }
            }
            this.proxima=null;
            repository.remove(this);
            return;
        }
        else if(previa==null && proxima!=null && !(proxima instanceof EnlaceCompuesto_1)){
            //CASO 7
            //System.out.println("CASO 7");
            proxima.setPrevMaquina(null);
            Comando comando = Comando.getLastComando();
            Comando inverse = comando.getInverse();
            for(int i=0;i<repository.size();i++)
                if((repository.get(i) instanceof Enlace_1) && ((Maquina)repository.get(i)).proxima==this){
                    ((Enlace_1)repository.get(i)).setProxMaquina(proxima);
                    if(Comando.flagDelete){
                        comando.addComando(new ComandoEPRX(repository.get(i),(Vector2)repository,proxima));
                        inverse.addComando(new ComandoEPRX(repository.get(i),(Vector2)repository,this));
                    }
                }
            repository.remove(this);
            if(this.isInicial()){
                this.setInicial(false);
                proxima.setInicial(true);
                ((Vector2)repository).inicial = proxima;
            }
            return;
        }
        else if(previa==null && proxima==null){
            //CASO 6
            //System.out.println("CASO 6");
            java.util.Vector enlacesRemovidos = new java.util.Vector();
            for(int i=0;i<repository.size();i++)
                if((repository.get(i) instanceof Enlace_1) && ((Maquina)repository.get(i)).proxima==this){
                    //if(!(repository.get(i) instanceof AutoEnlace)) ((Maquina)repository.get(i)).previa.setProxMaquina(null);
                    enlacesRemovidos.add(repository.get(i));
                }
            
            Comando comando = Comando.getLastComando();
            Comando inverse = comando.getInverse();
            Enumeration enRem = enlacesRemovidos.elements();
            while(enRem.hasMoreElements()){
                //repository.remove(enRem.nextElement());
                Enlace_1 enlace = (Enlace_1) enRem.nextElement();  
                enlace.deleteMachine(repository);
                if(Comando.flagDelete){
                    comando.addComando(new ComandoEM(enlace,(Vector2)repository));
                    inverse.addComando(new ComandoIE(enlace,(Vector2)repository));
                }
            }
            repository.remove(this);
            
        }
           
     }
     
      public void moveForward2(){
        
        if(flagUR) return;
        
        int delta = this.getDelta();
        this.x0+=delta;
        this.boundRectangle.setLocation((int)this.boundRectangle.getX()+delta,(int)this.boundRectangle.getY());
        this.leftRectangle.setLocation((int)this.leftRectangle.getX()+delta,(int)this.boundRectangle.getY());
        this.rightRectangle.setLocation((int)this.rightRectangle.getX()+delta,(int)this.rightRectangle.getY());
        if(this.previa!=null) this.previa.moveForward2(delta);
        
        
    }
    
    public void moveForward2(int delta){
        
        if(flagUR) return;
        
        this.x0+=delta;
        this.boundRectangle.setLocation((int)this.boundRectangle.getX()+delta,(int)this.boundRectangle.getY());
        this.leftRectangle.setLocation((int)this.leftRectangle.getX()+delta,(int)this.boundRectangle.getY());
        this.rightRectangle.setLocation((int)this.rightRectangle.getX()+delta,(int)this.rightRectangle.getY());
        if(this.previa!=null) this.previa.moveForward2(delta);
             
    }
    
    
    public void moveForward(){
        
        if(flagUR) return;
        
        int delta = this.getDelta();
        this.x0+=delta;
        this.boundRectangle.setLocation((int)this.boundRectangle.getX()+delta,(int)this.boundRectangle.getY());
        this.leftRectangle.setLocation((int)this.leftRectangle.getX()+delta,(int)this.boundRectangle.getY());
        this.rightRectangle.setLocation((int)this.rightRectangle.getX()+delta,(int)this.rightRectangle.getY());
        if(this.proxima!=null && !(this.proxima instanceof EnlaceCompuesto_1)) this.proxima.moveForward(delta);
             
    }
    
     public void moveForward(int delta){
         
        if(flagUR) return;
        
        this.x0+=delta;
        this.boundRectangle.setLocation((int)this.boundRectangle.getX()+delta,(int)this.boundRectangle.getY());
        this.leftRectangle.setLocation((int)this.leftRectangle.getX()+delta,(int)this.boundRectangle.getY());
        this.rightRectangle.setLocation((int)this.rightRectangle.getX()+delta,(int)this.rightRectangle.getY());
        if(this.proxima!=null && !(this.proxima instanceof EnlaceCompuesto_1)) this.proxima.moveForward3(this.getDelta());
             
    }
    
    public void moveForward3(int delta){
        
        if(flagUR) return;
        
        this.x0+=delta;
        this.boundRectangle.setLocation((int)this.boundRectangle.getX()+delta,(int)this.boundRectangle.getY());
        this.leftRectangle.setLocation((int)this.leftRectangle.getX()+delta,(int)this.boundRectangle.getY());
        this.rightRectangle.setLocation((int)this.rightRectangle.getX()+delta,(int)this.rightRectangle.getY());
        if(this.proxima!=null && !(this.proxima instanceof EnlaceCompuesto_1)) this.proxima.moveForward3(delta);
             
    }
    
    public void moveRewind(){
        
        if(flagUR) return;
        
        int delta = this.getDelta();
        this.x0-=delta;
        this.boundRectangle.setLocation((int)this.boundRectangle.getX()-delta,(int)this.boundRectangle.getY());
        this.leftRectangle.setLocation((int)this.leftRectangle.getX()-delta,(int)this.boundRectangle.getY());
        this.rightRectangle.setLocation((int)this.rightRectangle.getX()-delta,(int)this.rightRectangle.getY());
        if(this.previa!=null) this.previa.moveRewind(delta);
       
    }
    
    public void moveRewind(int delta){
        
        if(flagUR) return;
        
        this.x0-=delta;
        this.boundRectangle.setLocation((int)this.boundRectangle.getX()-delta,(int)this.boundRectangle.getY());
        this.leftRectangle.setLocation((int)this.leftRectangle.getX()-delta,(int)this.boundRectangle.getY());
        this.rightRectangle.setLocation((int)this.rightRectangle.getX()-delta,(int)this.rightRectangle.getY());
        if(this.previa!=null) this.previa.moveRewind(delta);
       
    }
    
     public void mover(int dx,int dy){
     
      
      x0+=dx;
      y0+=dy;
      this.boundRectangle.setLocation((int)this.boundRectangle.getX()+dx,(int)this.boundRectangle.getY()+dy);
      this.leftRectangle.setLocation((int)this.leftRectangle.getX()+dx,(int)this.boundRectangle.getY()+dy);
      this.rightRectangle.setLocation((int)this.rightRectangle.getX()+dx,(int)this.rightRectangle.getY()+dy);
      if(this.previa!=null) this.previa.moverPrevia(dx,dy);
      if(this.proxima!=null) this.proxima.moverProxima(dx,dy);
      
    }
    
    public void moverPrevia(int dx,int dy){
        
        x0+=dx;
        y0+=dy;
        this.boundRectangle.setLocation((int)this.boundRectangle.getX()+dx,(int)this.boundRectangle.getY()+dy);
        this.leftRectangle.setLocation((int)this.leftRectangle.getX()+dx,(int)this.boundRectangle.getY()+dy);
        this.rightRectangle.setLocation((int)this.rightRectangle.getX()+dx,(int)this.rightRectangle.getY()+dy);
        if(this.previa!=null) this.previa.moverPrevia(dx,dy);
        
    }
    
    public void moverProxima(int dx,int dy){
        
        x0+=dx;
        y0+=dy;
        this.boundRectangle.setLocation((int)this.boundRectangle.getX()+dx,(int)this.boundRectangle.getY()+dy);
        this.leftRectangle.setLocation((int)this.leftRectangle.getX()+dx,(int)this.boundRectangle.getY()+dy);
        this.rightRectangle.setLocation((int)this.rightRectangle.getX()+dx,(int)this.rightRectangle.getY()+dy);
        if(this.proxima!=null) this.proxima.moverProxima(dx,dy);
        
    }
    
    
    public void updateBounds(){
        java.awt.geom.Rectangle2D rect = getBounds(); //Maquina.FONT_TRI25.getStringBounds(getNombre(),new FontRenderContext(Maquina.FONT_TRI25.getTransform(),true,true));
        boundRectangle.setLocation(x0,y0-(int)Math.abs(0.8*rect.getHeight()));
        leftRectangle.setLocation(x0,y0-(int)Math.abs(0.8*rect.getHeight()));
        rightRectangle.setLocation(x0+(int)Math.abs(0.5*rect.getWidth()),y0-(int)Math.abs(0.8*rect.getHeight()));
    }
    

    public void getAttributes(int x,int y){
        
            return;
    }
    
    
     public int showDialog(int numOfTapes,boolean addComando){
        
        return 0;
    }
    
 
    public boolean isInicial(){
        
        return inicial;
    }
    
    public void setInicial(boolean newInicial){
        
        inicial = newInicial; 
    }
    
    public int getDelta(){
        
        return 20;
        
    }
    
    public abstract String getXML();
    
    public void setScrollBars(JScrollPane scrollPane){
        
        int h = scrollPane.getHorizontalScrollBar().getModel().getValue();
        int v = scrollPane.getVerticalScrollBar().getModel().getValue();
        Rectangle rect = scrollPane.getViewportBorderBounds();
        rect.setLocation(h,v);
        
        //if(!(rect.getMinX()<=x0&&x0+30<=rect.getMaxX()&&rect.getMinY()<=y0-30&&y0<=rect.getMaxY())){
            //scrollPane.getHorizontalScrollBar().getModel().setValue(x0-30);
            //scrollPane.getVerticalScrollBar().getModel().setValue(y0-(int)Maquina.RECT_INICIAL.getHeight()-30); 
        //    scrollPane.getHorizontalScrollBar().getModel().setValue(h+30);
        //    scrollPane.getVerticalScrollBar().getModel().setValue(v-30);
        //}
        
        if(rect.getMinX()>x0) 
            scrollPane.getHorizontalScrollBar().getModel().setValue(h+(x0-(int)rect.getMinX()));
        else if(rect.getMaxX()<x0+30) 
            scrollPane.getHorizontalScrollBar().getModel().setValue(h+30);
        
        if(rect.getMinY()>y0-30) 
            scrollPane.getVerticalScrollBar().getModel().setValue(v-30);
        else if(rect.getMaxY()<y0) 
            scrollPane.getVerticalScrollBar().getModel().setValue(v+y0-(int)rect.getMaxY());
    }
    
    /** Getter for property boundRectangle.
     * @return Value of property boundRectangle.
     */
    public java.awt.Rectangle getBoundRectangle() {
        return boundRectangle;
    }    
    
    /** Setter for property boundRectangle.
     * @param boundRectangle New value of property boundRectangle.
     */
    public void setBoundRectangle(java.awt.Rectangle boundRectangle) {
        this.boundRectangle = boundRectangle;
    }
    
}