/*
 * DialogEnlace_.java
 *
 * Created on 28 de noviembre de 2002, 05:23 PM
 */

/**
 *
 * @author  Administrador
 */
import javax.swing.*;
import javax.swing.ListSelectionModel;
import java.awt.font.FontRenderContext;
import java.util.*;
import java.awt.*;
import javax.swing.event.*;
import java.awt.event.*;

public class DialogAutoenlace extends javax.swing.JDialog {
    
    /** A return status code - returned if Cancel button has been pressed */
    public static final int RET_CANCEL = 0;
    /** A return status code - returned if OK button has been pressed */
    public static final int RET_OK = 1;
    
    public static final Color backColor = new Color(204,204,204);
    
    public static int counter=0;
    private Hashtable repositoriosCintas;
    private Vector simbolos;
    private Vector variables;
    private Vector parametros;
    private java.util.Comparator comparator;
    private AutoEnlace autoEnlace;
    private CondicionEnlace condicionEnlace;
    private boolean addComando;
    
    /** Creates new form DialogEnlace_ */
    public DialogAutoenlace(java.awt.Frame parent, boolean modal, int numOfTapes, AutoEnlace newAutoEnlace,boolean addComando) {
        super(parent, modal);
        initComponents();
        
        this.autoEnlace = newAutoEnlace;
        this.condicionEnlace = this.autoEnlace.condicionEnlace;
        this.addComando = addComando;
        this.repositoriosCintas = new Hashtable();
        this.simbolos = new Vector();
        this.variables = new Vector();
        this.parametros = new Vector();
        comparator = new Comparator(){
          public int compare(Object o1,Object o2){
            RepositorioOpciones ro1 = (RepositorioOpciones) o1;
            RepositorioOpciones ro2 = (RepositorioOpciones) o2;
            
            return ro1.compareTo(ro2);
          }
        };
       
        //Vector simbolos = new Vector();
        simbolos.add("#");
        for(char i='a';i<='z';i++)
           simbolos.add(String.valueOf(i));
        for(char i='0';i<='9';i++)
           simbolos.add(String.valueOf(i)); 
        this.jList1.setListData(simbolos);
        this.jList1.setFont(new Font("TIMESROMAN",Font.ITALIC,15));
        JScrollPane listPane1 = new JScrollPane(this.jList1);
        this.jPanel19.add(listPane1);
        
        //Vector variables = new Vector();
        this.jComboBox2.addItem("");
        for(int i=Hellada.ALPHA;i<=Hellada.OMEGA;i++){
           variables.add(Hellada.getChar(i));
           this.jComboBox2.addItem(Hellada.getChar(i));
        }
        this.jComboBox2.setBackground(Color.white);
        this.jComboBox2.setFont(new Font("TIMESROMAN",Font.ITALIC,15));
        this.jList2.setListData(variables);
        this.jList2.setFont(new Font("TIMESROMAN",Font.ITALIC,15));
        JScrollPane listPane2 = new JScrollPane(this.jList2);
        this.jPanel20.add(listPane2);
        
        //Vector parametros = new Vector();
        for(char i='A';i<='Z';i++)
           parametros.add(String.valueOf(i));
        this.jList3.setListData(parametros);
        this.jList3.setFont(new Font("TIMESROMAN",Font.ITALIC,15));
        JScrollPane listPane3 = new JScrollPane(this.jList3);
        this.jPanel21.add(listPane3);
        
        this.jComboBox1.setFont(new Font("TIMESROMAN",Font.ITALIC,15));
        this.jComboBox1.setBackground(Color.white);
        for(int i=1;i<=numOfTapes;i++)
            this.jComboBox1.addItem(String.valueOf(i));
        
        jPanel13.remove(jPanel15);
        jPanel15 = new JPanel() {
            protected void paintComponent(Graphics g){
                super.paintComponent(g);
                if(repositoriosCintas.size()==0) return;
                java.util.List list = new java.util.ArrayList(repositoriosCintas.values());
                java.util.Collections.sort(list,comparator);      
                java.util.Iterator iter = list.iterator();
                //Enumeration en2 = repositoriosCintas.elements();
                int x0 = 5;
                int y0 = 20;
                String string="";
                while(iter.hasNext()){
                    RepositorioOpciones ro = (RepositorioOpciones)iter.next();
                    Integer indexCinta = ro.getIndexCinta();
                    string=repositoryToString(ro);
                    java.awt.geom.Rectangle2D rect = Maquina.FONT_TRI14.getStringBounds(string,new FontRenderContext(Maquina.FONT_TRI14.getTransform(),true,true));
                    g.drawString(string,x0,y0);
                    if(ro.isNot()) g.drawLine(x0,y0-(int) rect.getHeight()+4,x0+(int) rect.getWidth(),y0-(int) rect.getHeight()+4);
                    x0+=(int) rect.getWidth()+1;
                }
                //java.awt.geom.Rectangle2D rect = Maquina.FONT_TRI14.getStringBounds(string,new FontRenderContext(Maquina.FONT_TRI14.getTransform(),true,true));
                //g.drawString(string,x0,y0);
                //if(jCheckBox1.isSelected()) g.drawLine(x0+2,y0-(int) rect.getHeight()+4,x0+(int) rect.getWidth()+2,y0-(int) rect.getHeight()+4);
            }
               
         };
        
        jPanel15.setBackground(java.awt.Color.white);
        jPanel15.setBorder(new javax.swing.border.BevelBorder(javax.swing.border.BevelBorder.RAISED));
        jPanel15.setFont(Maquina.FONT_TRI14);
        jPanel15.setPreferredSize(new java.awt.Dimension(136, 30));
        jPanel13.add(jPanel15, java.awt.BorderLayout.NORTH);
        
        (this.jList1.getSelectionModel()).addListSelectionListener(new SharedListSelectionHandlerSimbolos(jList1,this.repositoriosCintas,this.jComboBox1));
        (this.jList2.getSelectionModel()).addListSelectionListener(new SharedListSelectionHandlerVariables(jList2,this.repositoriosCintas,this.jComboBox1));
        (this.jList3.getSelectionModel()).addListSelectionListener(new SharedListSelectionHandlerParametros(jList3,this.repositoriosCintas,this.jComboBox1));
        
        /*Settings de los valores definidos en condicionEnlace*/
        //numOfTapes = (int)Math.max(condicionEnlace.operandosIzquierdo.size(),condicionEnlace.operandosDerecho.size());
        java.util.List list = new ArrayList();
        Enumeration enIzq = condicionEnlace.operandosIzquierdo.keys();
        while(enIzq.hasMoreElements())
            list.add(enIzq.nextElement());
        Enumeration enDer = condicionEnlace.operandosDerecho.keys();
        while(enDer.hasMoreElements()){
            Object obj = enDer.nextElement();
            if(!list.contains(obj)) list.add(obj);
        }
        Collections.sort(list);
        for(int i=0;i<list.size();i++){
            Integer indexCinta = (Integer)list.get(i);
            RepositorioOpciones ro = new RepositorioOpciones(indexCinta);
            ro.setIndexCinta(indexCinta);
            
            if(condicionEnlace.operandosNots.containsKey(indexCinta)){
                Boolean not = (Boolean)condicionEnlace.operandosNots.get(indexCinta);
                ro.setNot(not.booleanValue());
            }
            
            if(condicionEnlace.operandosIzquierdo.containsKey(indexCinta)){
                String operandoIzquierdo = (String)condicionEnlace.operandosIzquierdo.get(indexCinta);
                ro.setOperandoIzquierdo(this.variables.indexOf(operandoIzquierdo)+1);
            }
            
            if(condicionEnlace.operandosDerecho.containsKey(indexCinta)){
                Enumeration operandosDerecho = ((Vector)condicionEnlace.operandosDerecho.get(indexCinta)).elements();
                int countSimbolos=0,countVariables=0,countParametros=0;
                while(operandosDerecho.hasMoreElements()){
                    String operandoDerecho = (String)operandosDerecho.nextElement();
                    if(CondicionEnlace.isNombreSimbolo(operandoDerecho))
                        countSimbolos++;
                    else if(CondicionEnlace.isNombreVariable(operandoDerecho))
                        countVariables++;
                    else
                        countParametros++;
                }
                
                ro.simbolos = new int[countSimbolos];
                ro.variables = new int[countVariables];
                ro.parametros = new int[countParametros];
                countSimbolos = countVariables = countParametros = 0;
                
                operandosDerecho = null;
                operandosDerecho = ((Vector)condicionEnlace.operandosDerecho.get(indexCinta)).elements();
                
                while(operandosDerecho.hasMoreElements()){
                    String operandoDerecho = (String)operandosDerecho.nextElement();
                    if(CondicionEnlace.isNombreSimbolo(operandoDerecho))
                        ro.simbolos[countSimbolos++] = this.simbolos.indexOf(operandoDerecho);
                    else if(CondicionEnlace.isNombreVariable(operandoDerecho))   
                        ro.variables[countVariables++] = this.variables.indexOf(operandoDerecho);
                    else 
                        ro.parametros[countParametros++] = this.parametros.indexOf(operandoDerecho);  
                }
            }
            this.repositoriosCintas.put(indexCinta,ro);         
        } 
        
        this.jCheckBox1.setSelected(condicionEnlace.getNot());
        if(list.size()!=0) this.jComboBox1.setSelectedIndex(((Integer)list.get(0)).intValue());
        this.accionComboboxCinta(null);
        
        this.lastOrientationButton = new JButton();
        JButton[] arrayBO = new JButton[4];
        arrayBO[0] = jButton8;
        arrayBO[1] = jButton10;
        arrayBO[2] = jButton7;
        arrayBO[3] = jButton9;
        if(this.autoEnlace.previa.previa!=null) {
            jButton9.setEnabled(false);
            System.out.println("previa!=null");
        }
        this.changeOrientacion(newAutoEnlace.getOrientacion(),arrayBO[newAutoEnlace.getOrientacion()]);
        arrayBO = null;
    }
      
    class SharedListSelectionHandler implements ListSelectionListener {
        
        protected JList jList;
        protected Hashtable repositoriosCintas;
        protected JComboBox jComboBox;
        protected RepositorioOpciones ro=null;
        SharedListSelectionHandler(JList newJList,Hashtable newRepositoriosCintas,JComboBox newJComboBox){
            
            jList = newJList;
            repositoriosCintas = newRepositoriosCintas;
            jComboBox = newJComboBox;
        }
        
        public void valueChanged(ListSelectionEvent e) {
            if(e.getValueIsAdjusting()) return;
            
            Integer indexCinta = Integer.valueOf(String.valueOf(jComboBox.getSelectedIndex()));
            ro = (RepositorioOpciones)repositoriosCintas.get(indexCinta);
        }
    }
    
    class SharedListSelectionHandlerSimbolos extends SharedListSelectionHandler{
        
        SharedListSelectionHandlerSimbolos(JList newJList,Hashtable newRepositoriosCintas,JComboBox newJComboBox){
            super(newJList,newRepositoriosCintas,newJComboBox); 
        }
        
         public void valueChanged(ListSelectionEvent e) {
            super.valueChanged(e);
            if(e.getValueIsAdjusting()) return;
            if(ro==null) return;
            ro.simbolos = this.jList.getSelectedIndices();
            paintDisplay();
         }
        
    }
    
    class SharedListSelectionHandlerVariables extends SharedListSelectionHandler{
        
        SharedListSelectionHandlerVariables(JList newJList,Hashtable newRepositoriosCintas,JComboBox newJComboBox){
            super(newJList,newRepositoriosCintas,newJComboBox); 
        }
        
         public void valueChanged(ListSelectionEvent e) {
            super.valueChanged(e);
            if(e.getValueIsAdjusting()) return;
            if(ro==null) return;
            ro.variables = this.jList.getSelectedIndices(); 
            paintDisplay();
         }
        
    }
    
    class SharedListSelectionHandlerParametros extends SharedListSelectionHandler{
        
        SharedListSelectionHandlerParametros(JList newJList,Hashtable newRepositoriosCintas,JComboBox newJComboBox){
            super(newJList,newRepositoriosCintas,newJComboBox); 
        }
        
         public void valueChanged(ListSelectionEvent e) {
            super.valueChanged(e);
            if(e.getValueIsAdjusting()) return;
            if(ro==null) return;
            ro.parametros = this.jList.getSelectedIndices();
            paintDisplay();
         }
        
    }
    
    public class RepositorioOpciones implements Comparable{
        
        private Integer indexCinta;
        private int operandoIzquierdo;
        private int orientacion;
        public int[] simbolos;
        public int[] variables;
        public int[] parametros;
        private boolean not; 
        
        public RepositorioOpciones(Integer newIndexCinta){
            
            operandoIzquierdo = 0;
            simbolos = new int[0];
            variables = new int[0];
            parametros = new int[0];
            not = false;
            indexCinta = newIndexCinta;
        }
        
        /** Getter for property not.
         * @return Value of property not.
         */
        public boolean isNot() {
            return not;
        }        
        
        /** Setter for property not.
         * @param not New value of property not.
         */
        public void setNot(boolean not) {
            this.not = not;
        }
        
        public void clearSimbolos(){
            simbolos = null;
            simbolos = new int[0];   
        }
        
        public void clearVariables(){
            variables = null;
            variables = new int[0];  
        }
        
        public void clearParametros(){
            parametros = null;  
            parametros = new int[0];   
        }
        
        public void clear(){
            simbolos = null;
            variables = null;
            parametros = null;  
            simbolos = new int[0];
            variables = new int[0];
            parametros = new int[0];    
        }
        
        /** Getter for property operandoIzquierdo.
         * @return Value of property operandoIzquierdo.
         */
        public int getOperandoIzquierdo() {
            return operandoIzquierdo;
        }
        
        /** Setter for property operandoIzquierdo.
         * @param operandoIzquierdo New value of property operandoIzquierdo.
         */
        public void setOperandoIzquierdo(int operandoIzquierdo) {
            this.operandoIzquierdo = operandoIzquierdo;
        }
         
        /** Getter for property indexCinta.
         * @return Value of property indexCinta.
         */
        public java.lang.Integer getIndexCinta() {
            return indexCinta;
        }
        
        /** Setter for property indexCinta.
         * @param indexCinta New value of property indexCinta.
         */
        public void setIndexCinta(java.lang.Integer indexCinta) {
            this.indexCinta = indexCinta;
        }
        
       /* public int compareTo(RepositorioOpciones ro){
            
            return this.indexCinta.compareTo(ro.getIndexCinta());
            
        } */
        
        public int compareTo(java.lang.Object obj) {
            
            return this.indexCinta.compareTo(((RepositorioOpciones) obj).getIndexCinta());
        }
        
        /** Getter for property orientacion.
         * @return Value of property orientacion.
         */
        public int getOrientacion() {
            return orientacion;
        }
        
        /** Setter for property orientacion.
         * @param orientacion New value of property orientacion.
         */
        public void setOrientacion(int orientacion) {
            this.orientacion = orientacion;
        }
        
    }
    
    public String repositoryToString(RepositorioOpciones ro){
        
        String out="[";
        String oi = null;
        out+=((oi = (String)this.jComboBox2.getItemAt(ro.getOperandoIzquierdo())).length()==0?"":(oi+" = "));
        
        String sSimbolos = "";
      
        for(int i=0;i<ro.simbolos.length;i++){
            sSimbolos+=(String)simbolos.get(ro.simbolos[i]);
            if(i!=ro.simbolos.length-1) sSimbolos+=",";
        }
        
        String sVariables = "";
        for(int i=0;i<ro.variables.length;i++){
            sVariables+=(String)variables.get(ro.variables[i]);
            if(i!=ro.variables.length-1) sVariables+=",";
        }
        
        String sParametros = "";
        for(int i=0;i<ro.parametros.length;i++){
            sParametros+=(String)parametros.get(ro.parametros[i]);
            if(i!=ro.parametros.length-1) sParametros+=",";
        }
        
        if(ro.simbolos.length!=0 && (sVariables.length()!=0 || sParametros.length()!=0)) sVariables = "," + sVariables;
        if(ro.variables.length!=0 && sParametros.length()!=0) sParametros = "," + sParametros;
        
        if(ro.getOperandoIzquierdo()==0 && sSimbolos.length()==0 && sVariables.length()==0 && sParametros.length()==0)
            out = "";
        else
            out+= sSimbolos + sVariables + sParametros + ";" + (ro.getIndexCinta().intValue()+1) + "]";
        
        return out;
        
    }
    
    private void changeOrientacion(int newOrientacion,JButton currentButton){
        
        if(this.lastOrientationButton==currentButton) return;
        currentButton.setBackground(Color.cyan);
        this.lastOrientationButton.setBackground(DialogAutoenlace.backColor);
        orientacion = newOrientacion;
        this.lastOrientationButton = currentButton;  
    }
    
    

    /** This method is called from within the constructor to
     * initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is
     * always regenerated by the Form Editor.
     */
    private void initComponents() {//GEN-BEGIN:initComponents
        jPanel13 = new javax.swing.JPanel();
        jPanel14 = new javax.swing.JPanel();
        jPanel19 = new javax.swing.JPanel();
        jButton4 = new javax.swing.JButton();
        jList1 = new javax.swing.JList();
        jPanel20 = new javax.swing.JPanel();
        jList2 = new javax.swing.JList();
        jButton5 = new javax.swing.JButton();
        jPanel21 = new javax.swing.JPanel();
        jList3 = new javax.swing.JList();
        jButton6 = new javax.swing.JButton();
        jPanel15 = new javax.swing.JPanel();
        jPanel16 = new javax.swing.JPanel();
        jPanel3 = new javax.swing.JPanel();
        jComboBox1 = new javax.swing.JComboBox();
        jPanel4 = new javax.swing.JPanel();
        jComboBox2 = new javax.swing.JComboBox();
        jPanel2 = new javax.swing.JPanel();
        jButton7 = new javax.swing.JButton();
        jButton8 = new javax.swing.JButton();
        jButton9 = new javax.swing.JButton();
        jButton10 = new javax.swing.JButton();
        jPanel5 = new javax.swing.JPanel();
        jPanel17 = new javax.swing.JPanel();
        jButton1 = new javax.swing.JButton();
        jButton3 = new javax.swing.JButton();
        jButton2 = new javax.swing.JButton();
        jPanel1 = new javax.swing.JPanel();
        jCheckBox1 = new javax.swing.JCheckBox();
        
        setTitle("Condiciones de Transici\u00f3n");
        setResizable(false);
        addWindowListener(new java.awt.event.WindowAdapter() {
            public void windowClosing(java.awt.event.WindowEvent evt) {
                closeDialog(evt);
            }
        });
        
        jPanel13.setLayout(new java.awt.BorderLayout());
        
        jPanel14.setLayout(new java.awt.GridLayout(3, 1));
        
        jPanel14.setBorder(new javax.swing.border.TitledBorder(""));
        jPanel14.setMinimumSize(new java.awt.Dimension(300, 235));
        jPanel14.setPreferredSize(new java.awt.Dimension(200, 235));
        jPanel19.setLayout(new javax.swing.BoxLayout(jPanel19, javax.swing.BoxLayout.X_AXIS));
        
        jPanel19.setBorder(new javax.swing.border.TitledBorder("S\u00edmbolos"));
        jPanel19.setPreferredSize(new java.awt.Dimension(100, 25));
        jButton4.setIcon(new javax.swing.ImageIcon(getClass().getResource("/images/Delete16.gif")));
        jButton4.setToolTipText("Limpiar");
        jButton4.setPreferredSize(new java.awt.Dimension(26, 26));
        jButton4.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jButton4ActionPerformed(evt);
            }
        });
        
        jPanel19.add(jButton4);
        
        jPanel19.add(jList1);
        
        jPanel14.add(jPanel19);
        
        jPanel20.setLayout(new javax.swing.BoxLayout(jPanel20, javax.swing.BoxLayout.X_AXIS));
        
        jPanel20.setBorder(new javax.swing.border.TitledBorder("Variables"));
        jPanel20.add(jList2);
        
        jButton5.setIcon(new javax.swing.ImageIcon(getClass().getResource("/images/Delete16.gif")));
        jButton5.setToolTipText("Limpiar");
        jButton5.setPreferredSize(new java.awt.Dimension(26, 26));
        jButton5.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jButton5ActionPerformed(evt);
            }
        });
        
        jPanel20.add(jButton5);
        
        jPanel14.add(jPanel20);
        
        jPanel21.setLayout(new javax.swing.BoxLayout(jPanel21, javax.swing.BoxLayout.X_AXIS));
        
        jPanel21.setBorder(new javax.swing.border.TitledBorder("Par\u00e1metros"));
        jPanel21.add(jList3);
        
        jButton6.setIcon(new javax.swing.ImageIcon(getClass().getResource("/images/Delete16.gif")));
        jButton6.setToolTipText("Limpiar");
        jButton6.setPreferredSize(new java.awt.Dimension(26, 26));
        jButton6.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jButton6ActionPerformed(evt);
            }
        });
        
        jPanel21.add(jButton6);
        
        jPanel14.add(jPanel21);
        
        jPanel13.add(jPanel14, java.awt.BorderLayout.EAST);
        
        jPanel15.setBackground(java.awt.Color.white);
        jPanel15.setBorder(new javax.swing.border.BevelBorder(javax.swing.border.BevelBorder.RAISED));
        jPanel15.setFont(new java.awt.Font("Times New Roman", 2, 13));
        jPanel15.setPreferredSize(new java.awt.Dimension(136, 30));
        jPanel13.add(jPanel15, java.awt.BorderLayout.NORTH);
        
        jPanel16.setLayout(new java.awt.GridLayout(3, 1));
        
        jPanel16.setPreferredSize(new java.awt.Dimension(150, 75));
        jPanel3.setLayout(new java.awt.GridBagLayout());
        java.awt.GridBagConstraints gridBagConstraints1;
        
        jPanel3.setBorder(new javax.swing.border.TitledBorder("Cinta"));
        jComboBox1.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                accionComboboxCinta(evt);
            }
        });
        
        gridBagConstraints1 = new java.awt.GridBagConstraints();
        gridBagConstraints1.gridx = 2;
        gridBagConstraints1.gridy = 0;
        gridBagConstraints1.fill = java.awt.GridBagConstraints.BOTH;
        jPanel3.add(jComboBox1, gridBagConstraints1);
        
        jPanel16.add(jPanel3);
        
        jPanel4.setLayout(new java.awt.GridBagLayout());
        java.awt.GridBagConstraints gridBagConstraints2;
        
        jPanel4.setBorder(new javax.swing.border.TitledBorder("Variable"));
        jComboBox2.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                actionOperandoIzquierdo(evt);
            }
        });
        
        gridBagConstraints2 = new java.awt.GridBagConstraints();
        gridBagConstraints2.gridx = 2;
        gridBagConstraints2.gridy = 1;
        jPanel4.add(jComboBox2, gridBagConstraints2);
        
        jPanel16.add(jPanel4);
        
        jPanel2.setLayout(new java.awt.GridBagLayout());
        java.awt.GridBagConstraints gridBagConstraints3;
        
        jPanel2.setBorder(new javax.swing.border.TitledBorder("Orientaci\u00f3n"));
        jButton7.setIcon(new javax.swing.ImageIcon(getClass().getResource("/images/Forward16.gif")));
        jButton7.setPreferredSize(new java.awt.Dimension(16, 16));
        jButton7.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jButton7ActionPerformed(evt);
            }
        });
        
        gridBagConstraints3 = new java.awt.GridBagConstraints();
        gridBagConstraints3.gridx = 2;
        gridBagConstraints3.gridy = 1;
        jPanel2.add(jButton7, gridBagConstraints3);
        
        jButton8.setIcon(new javax.swing.ImageIcon(getClass().getResource("/images/Up16.gif")));
        jButton8.setMaximumSize(new java.awt.Dimension(16, 16));
        jButton8.setPreferredSize(new java.awt.Dimension(16, 16));
        jButton8.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jButton8ActionPerformed(evt);
            }
        });
        
        gridBagConstraints3 = new java.awt.GridBagConstraints();
        gridBagConstraints3.gridx = 1;
        gridBagConstraints3.gridy = 0;
        jPanel2.add(jButton8, gridBagConstraints3);
        
        jButton9.setIcon(new javax.swing.ImageIcon(getClass().getResource("/images/Back16.gif")));
        jButton9.setPreferredSize(new java.awt.Dimension(16, 16));
        jButton9.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jButton9ActionPerformed(evt);
            }
        });
        
        gridBagConstraints3 = new java.awt.GridBagConstraints();
        gridBagConstraints3.gridx = 0;
        gridBagConstraints3.gridy = 1;
        jPanel2.add(jButton9, gridBagConstraints3);
        
        jButton10.setIcon(new javax.swing.ImageIcon(getClass().getResource("/images/Down16.gif")));
        jButton10.setPreferredSize(new java.awt.Dimension(16, 16));
        jButton10.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jButton10ActionPerformed(evt);
            }
        });
        
        gridBagConstraints3 = new java.awt.GridBagConstraints();
        gridBagConstraints3.gridx = 1;
        gridBagConstraints3.gridy = 2;
        jPanel2.add(jButton10, gridBagConstraints3);
        
        gridBagConstraints3 = new java.awt.GridBagConstraints();
        gridBagConstraints3.gridx = 1;
        gridBagConstraints3.gridy = 1;
        jPanel2.add(jPanel5, gridBagConstraints3);
        
        jPanel16.add(jPanel2);
        
        jPanel13.add(jPanel16, java.awt.BorderLayout.WEST);
        
        jButton1.setText("Aceptar");
        jButton1.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                aceptarAccion(evt);
            }
        });
        
        jPanel17.add(jButton1);
        
        jButton3.setText("Limpiar Todo");
        jButton3.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jButton3ActionPerformed(evt);
            }
        });
        
        jPanel17.add(jButton3);
        
        jButton2.setText("Cancelar");
        jButton2.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                cancelarAccion(evt);
            }
        });
        
        jPanel17.add(jButton2);
        
        jPanel13.add(jPanel17, java.awt.BorderLayout.SOUTH);
        
        jPanel1.setLayout(new java.awt.GridBagLayout());
        java.awt.GridBagConstraints gridBagConstraints4;
        
        jPanel1.setBorder(new javax.swing.border.TitledBorder("Not"));
        jCheckBox1.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                actionCheckBox(evt);
            }
        });
        
        gridBagConstraints4 = new java.awt.GridBagConstraints();
        jPanel1.add(jCheckBox1, gridBagConstraints4);
        
        jPanel13.add(jPanel1, java.awt.BorderLayout.CENTER);
        
        getContentPane().add(jPanel13, java.awt.BorderLayout.CENTER);
        
        pack();
        java.awt.Dimension screenSize = java.awt.Toolkit.getDefaultToolkit().getScreenSize();
        setSize(new java.awt.Dimension(400, 450));
        setLocation((screenSize.width-400)/2,(screenSize.height-450)/2);
    }//GEN-END:initComponents

    private void jButton10ActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jButton10ActionPerformed
        // Add your handling code here:
        this.changeOrientacion(AutoEnlace.SUR,(JButton)evt.getSource());
    }//GEN-LAST:event_jButton10ActionPerformed

    private void jButton7ActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jButton7ActionPerformed
        // Add your handling code here:
        this.changeOrientacion(AutoEnlace.ESTE,(JButton)evt.getSource());
    }//GEN-LAST:event_jButton7ActionPerformed

    private void jButton9ActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jButton9ActionPerformed
        // Add your handling code here:
        this.changeOrientacion(AutoEnlace.OESTE,(JButton)evt.getSource());
    }//GEN-LAST:event_jButton9ActionPerformed

    private void jButton8ActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jButton8ActionPerformed
        // Add your handling code here:
        this.changeOrientacion(AutoEnlace.NORTE,(JButton)evt.getSource());
    }//GEN-LAST:event_jButton8ActionPerformed

    private void jButton3ActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jButton3ActionPerformed
        // Add your handling code here:
        this.repositoriosCintas.clear();
        this.jComboBox1.setSelectedIndex(0);
        this.paintDisplay();
    }//GEN-LAST:event_jButton3ActionPerformed

    private void jButton6ActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jButton6ActionPerformed
        // Add your handling code here:
        Integer indexCinta = Integer.valueOf(String.valueOf(this.jComboBox1.getSelectedIndex()));
        RepositorioOpciones ro = (RepositorioOpciones)this.repositoriosCintas.get(indexCinta);
        ro.clearParametros();
        this.jList3.clearSelection();
        this.paintDisplay();
    }//GEN-LAST:event_jButton6ActionPerformed

    private void jButton5ActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jButton5ActionPerformed
        // Add your handling code here:
        Integer indexCinta = Integer.valueOf(String.valueOf(this.jComboBox1.getSelectedIndex()));
        RepositorioOpciones ro = (RepositorioOpciones)this.repositoriosCintas.get(indexCinta);
        ro.clearVariables();
        this.jList2.clearSelection();
        this.paintDisplay();
    }//GEN-LAST:event_jButton5ActionPerformed

    private void jButton4ActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jButton4ActionPerformed
        // Add your handling code here:
        Integer indexCinta = Integer.valueOf(String.valueOf(this.jComboBox1.getSelectedIndex()));
        RepositorioOpciones ro = (RepositorioOpciones)this.repositoriosCintas.get(indexCinta);
        ro.clearSimbolos();
        this.jList1.clearSelection();
        this.paintDisplay();
    }//GEN-LAST:event_jButton4ActionPerformed

    private void actionOperandoIzquierdo(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_actionOperandoIzquierdo
        // Add your handling code here:
        Integer indexCinta = Integer.valueOf(String.valueOf(this.jComboBox1.getSelectedIndex()));
        RepositorioOpciones ro = (RepositorioOpciones)this.repositoriosCintas.get(indexCinta);
        if(ro==null) return;
        ro.setOperandoIzquierdo(this.jComboBox2.getSelectedIndex());
        this.paintDisplay();
        
    }//GEN-LAST:event_actionOperandoIzquierdo

    private void actionCheckBox(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_actionCheckBox
        // Add your handling code here:
        Integer indexCinta = Integer.valueOf(String.valueOf(this.jComboBox1.getSelectedIndex()));
        RepositorioOpciones ro = (RepositorioOpciones)this.repositoriosCintas.get(indexCinta);
        ro.setNot(this.jCheckBox1.isSelected());
        this.paintDisplay();
    }//GEN-LAST:event_actionCheckBox

    private void accionComboboxCinta(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_accionComboboxCinta
        // Add your handling code here:
        //System.out.println("Cinta "+this.jComboBox1.getSelectedIndex()+1);
        
        Integer indexCinta = Integer.valueOf(String.valueOf(this.jComboBox1.getSelectedIndex()));
        RepositorioOpciones ro = null;
        Enumeration en = null;
        if(this.repositoriosCintas.containsKey(indexCinta)){
            
            ro = (RepositorioOpciones)this.repositoriosCintas.get(indexCinta);
            this.jCheckBox1.setSelected(ro.isNot());
            this.jComboBox2.setSelectedIndex(ro.getOperandoIzquierdo());
            this.jList1.setSelectedIndices(ro.simbolos);
            this.jList2.setSelectedIndices(ro.variables);
            this.jList3.setSelectedIndices(ro.parametros);
   
        }
        else{
            ro = new RepositorioOpciones(indexCinta);
            this.jCheckBox1.setSelected(ro.isNot());
            this.jComboBox2.setSelectedIndex(ro.getOperandoIzquierdo());
            this.jList1.setSelectedIndices(ro.simbolos);
            this.jList2.setSelectedIndices(ro.variables);
            this.jList3.setSelectedIndices(ro.parametros);
            
            this.repositoriosCintas.put(indexCinta,ro);  
        }
        this.paintDisplay();
                
    }//GEN-LAST:event_accionComboboxCinta

    private void cancelarAccion(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_cancelarAccion
        // Add your handling code here:
        doClose (RET_CANCEL);
    }//GEN-LAST:event_cancelarAccion

    private void aceptarAccion(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_aceptarAccion
        // Add your handling code here:
        Enumeration en = this.repositoriosCintas.elements();
        Vector operandosIzquierdoElegidos = new Vector();
        while(en.hasMoreElements()){            
            RepositorioOpciones ro = (RepositorioOpciones)en.nextElement();
            if(ro.getOperandoIzquierdo()==0) continue;
            Integer oi = new Integer(ro.getOperandoIzquierdo());
            if(operandosIzquierdoElegidos.contains(oi)){
                JOptionPane.showMessageDialog(this,"Existen variables de asignacin repetidas para las diferentes cintas.","JTV",JOptionPane.ERROR_MESSAGE);
                return;
            }
            else
                operandosIzquierdoElegidos.add(oi);                
        }
        operandosIzquierdoElegidos.clear();
        en = null;
        en = this.repositoriosCintas.elements();
        CondicionEnlace condicionEnlaceOld=null;
        int orientacionOld=AutoEnlace.OESTE;
        if(addComando){
            condicionEnlaceOld = (CondicionEnlace)condicionEnlace.clone();
            orientacionOld = this.autoEnlace.getOrientacion();
        }
        this.condicionEnlace.limpiarOperandosIzquierdo();
        this.condicionEnlace.limpiarOperandosDerecho();
        while(en.hasMoreElements()){
            RepositorioOpciones ro = (RepositorioOpciones)en.nextElement();
            
            if(ro.getOperandoIzquierdo()!=0)
                this.condicionEnlace.agregaOperandoIzquierdo((String)this.jComboBox2.getItemAt(ro.getOperandoIzquierdo()),ro.getIndexCinta().intValue());
           // else
           //     this.condicionEnlace.eliminaOperandoIzquierdo(ro.getIndexCinta().intValue());
            
            
            for(int i=0;i<ro.simbolos.length;i++)
                this.condicionEnlace.agregaOperandoDerecho((String)this.simbolos.get(ro.simbolos[i]),ro.getIndexCinta().intValue());
            
            for(int i=0;i<ro.variables.length;i++)
                this.condicionEnlace.agregaOperandoDerecho((String)this.variables.get(ro.variables[i]),ro.getIndexCinta().intValue());
            
            for(int i=0;i<ro.parametros.length;i++)
                this.condicionEnlace.agregaOperandoDerecho((String)this.parametros.get(ro.parametros[i]),ro.getIndexCinta().intValue());
            
             this.condicionEnlace.agregaOperandoNot(ro.isNot()?Boolean.TRUE:Boolean.FALSE,ro.getIndexCinta().intValue());
        }
        //this.condicionEnlace.setNot(this.jCheckBox1.isSelected());
        this.autoEnlace.setOrientacion(orientacion);
        if(addComando){
            ComandoECE comandoECE = new ComandoECE(this.autoEnlace,null,condicionEnlace);
            comandoECE.addComando(new ComandoEOA(this.autoEnlace,null,this.autoEnlace.getOrientacion()));
            ComandoECE comandoECEInverse = new ComandoECE(this.autoEnlace,null,condicionEnlaceOld);
            comandoECEInverse.addComando(new ComandoEOA(this.autoEnlace,null,orientacionOld));
            comandoECE.setInverse(comandoECEInverse);
            Comando.addComando2UR(comandoECE);
        }
        doClose (RET_OK);
    }//GEN-LAST:event_aceptarAccion

    /** Closes the dialog */
    private void closeDialog(java.awt.event.WindowEvent evt) {//GEN-FIRST:event_closeDialog
        setVisible(false);
        dispose();
    }//GEN-LAST:event_closeDialog
    
     private void doClose (int retStatus) {
        returnStatus = retStatus;
        setVisible (false);
        dispose ();
    }
    
    private void paintDisplay(){
        this.jPanel15.repaint();
    }
    /**
    * @param args the command line arguments
    */
    public static void main(String args[]) {
        DialogAutoenlace dv = new DialogAutoenlace(new javax.swing.JFrame (), true,4,new AutoEnlace(0,0,0,new L(0,0,0,null,null),AutoEnlace.ESTE),false);
        dv.setSize(400,400);
        dv.show();
    }

    /** Getter for property returnStatus.
     * @return Value of property returnStatus.
     */
    public int getReturnStatus() {
        return returnStatus;
    }    

    /** Setter for property returnStatus.
     * @param returnStatus New value of property returnStatus.
     */
    public void setReturnStatus(int returnStatus) {
        this.returnStatus = returnStatus;
    }
    
    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JPanel jPanel13;
    private javax.swing.JPanel jPanel14;
    private javax.swing.JPanel jPanel19;
    private javax.swing.JButton jButton4;
    private javax.swing.JList jList1;
    private javax.swing.JPanel jPanel20;
    private javax.swing.JList jList2;
    private javax.swing.JButton jButton5;
    private javax.swing.JPanel jPanel21;
    private javax.swing.JList jList3;
    private javax.swing.JButton jButton6;
    private javax.swing.JPanel jPanel15;
    private javax.swing.JPanel jPanel16;
    private javax.swing.JPanel jPanel3;
    private javax.swing.JComboBox jComboBox1;
    private javax.swing.JPanel jPanel4;
    private javax.swing.JComboBox jComboBox2;
    private javax.swing.JPanel jPanel2;
    private javax.swing.JButton jButton7;
    private javax.swing.JButton jButton8;
    private javax.swing.JButton jButton9;
    private javax.swing.JButton jButton10;
    private javax.swing.JPanel jPanel5;
    private javax.swing.JPanel jPanel17;
    private javax.swing.JButton jButton1;
    private javax.swing.JButton jButton3;
    private javax.swing.JButton jButton2;
    private javax.swing.JPanel jPanel1;
    private javax.swing.JCheckBox jCheckBox1;
    // End of variables declaration//GEN-END:variables
    private int returnStatus = RET_CANCEL;
    private JButton lastOrientationButton;
    private int orientacion;
}
