/** * @(#)Arrow.java * * Copyright (c) 2000 by Sundar Dorai-Raj
  * * @author Sundar Dorai-Raj
  * * Email: sdoraira@vt.edu <../../contact.html>
  * * This program is free software; you can redistribute it and/or
  * * modify it under the terms of the GNU General Public License 
  * * as published by the Free Software Foundation; either version 2 
  * * of the License, or (at your option) any later version, 
  * * provided that any use properly credits the author. 
  * * This program is distributed in the hope that it will be useful,
  * * but WITHOUT ANY WARRANTY; without even the implied warranty of
  * * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
  * * GNU General Public License for more details at <http://www.gnu.org> * * */

import java.awt.*;

public class Arrow {
  public static final int SIDE_LEAD=0,
                          SIDE_TRAIL=1,
                          SIDE_BOTH=2,
                          SIDE_NONE=3;
  public final double pi=Math.PI;
  
  
  private int[] xPoints;
  private int[] yPoints;
  
  public Arrow () { 
      xPoints = new int[3];
      yPoints = new int[3];
 }

  public void drawArrow(Graphics g,
                        int xi,int yi,
                        int xf,int yf
                        ) {
                  
    double length = Math.sqrt(Math.pow(xf-xi,2.0)+Math.pow(yf-yi,2.0));
    double theta=0;
    //double theta = Math.atan((yf-yi)/(xf-xi));
    if(xf-xi!=0)
       theta = Math.atan(-(yf-yi)/(xf-xi));
    
    int side = Arrow.SIDE_LEAD;
   
    
      g.drawLine(xi,yi,xf,yf);

      
          //drawArrow(g,x1,y1,theta+5*pi/4,8,SIDE_NONE);
          //drawArrow(g,x1,y1,theta+3*pi/4,8,SIDE_NONE);
          
          //drawArrow(g,x1,y1,theta+7*pi/6,8,SIDE_NONE);
          //drawArrow(g,x1,y1,theta+5*pi/6,8,SIDE_NONE);
      
          xPoints[0] = xf;
          yPoints[0] = yf;
      if(xi<xf){   
          xPoints[1] = (int)Math.ceil(xf + 8*Math.cos(theta+7*pi/6));
          yPoints[1] = (int)Math.ceil(yf - 8*Math.sin(theta+7*pi/6));
          
          xPoints[2] = (int)Math.ceil(xf + 8*Math.cos(theta+5*pi/6));
          yPoints[2] = (int)Math.ceil(yf - 8*Math.sin(theta+5*pi/6));
      }    
      else if(xi>xf){
          xPoints[1] = (int)Math.ceil(xf + 8*Math.cos(theta-pi/6));
          yPoints[1] = (int)Math.ceil(yf - 8*Math.sin(theta-pi/6));
          
          xPoints[2] = (int)Math.ceil(xf + 8*Math.cos(theta+pi/6));
          yPoints[2] = (int)Math.ceil(yf - 8*Math.sin(theta+pi/6));
      }
      else{
          if(yi<yf){
            xPoints[1] = (int)Math.ceil(xf - 8*Math.sin(7*pi/6));
            yPoints[1] = (int)Math.ceil(yf + 8*Math.cos(7*pi/6));
          
            xPoints[2] = (int)Math.ceil(xf - 8*Math.sin(5*pi/6));
            yPoints[2] = (int)Math.ceil(yf + 8*Math.cos(5*pi/6));
          }
          else{
            xPoints[1] = (int)Math.ceil(xf - 8*Math.sin(-pi/6));
            yPoints[1] = (int)Math.ceil(yf + 8*Math.cos(-pi/6));
          
            xPoints[2] = (int)Math.ceil(xf - 8*Math.sin(pi/6));
            yPoints[2] = (int)Math.ceil(yf + 8*Math.cos(pi/6));
          }
      }
          
          g.fillPolygon(xPoints, yPoints,3);
  }        
  
}


